package com.metapace.printer.sample;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.RadioGroup;
import android.widget.Toast;

import com.metapace.thermalprinter.MetapacePrinter;

public class Print1dBarcodeActivity extends Activity {
	private EditText mDataEdit;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_print_barcode);
		
		mDataEdit = (EditText) findViewById(R.id.editText1);
		
		RadioGroup radioGroup = (RadioGroup) findViewById(R.id.radioGroup1);
		radioGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
			
			public void onCheckedChanged(RadioGroup group, int checkedId) {
				switch (checkedId) {
				case R.id.radio0:
					mDataEdit.setText("012345678905");
						break;
				case R.id.radio1:
					mDataEdit.setText("012345678905");
						break;
				case R.id.radio2:
					mDataEdit.setText("4711234567899");
						break;
				case R.id.radio3:
					mDataEdit.setText("47112346");
						break;
				case R.id.radio4:
					mDataEdit.setText("*ANDY*");
						break;
				case R.id.radio5:
					mDataEdit.setText("1234567895");
						break;
				case R.id.radio6:
					mDataEdit.setText("A1234567B");
						break;
				case R.id.radio7:
					mDataEdit.setText("12341555");
						break;
				case R.id.radio8:
					mDataEdit.setText("12345");
						break;
				}
				
			}
		});
		
		Button button = (Button) findViewById(R.id.button1);
		button.setOnClickListener(new View.OnClickListener() {

			public void onClick(View v) {
				printBarCode();
			}
		});
	}

	private void printBarCode() {
		int barCodeSystem = 0;
		RadioGroup radioGroup = (RadioGroup) findViewById(R.id.radioGroup1);
		switch (radioGroup.getCheckedRadioButtonId()) {
		case R.id.radio0:
			barCodeSystem = MetapacePrinter.BAR_CODE_UPC_A;
				break;
		case R.id.radio1:
			barCodeSystem = MetapacePrinter.BAR_CODE_UPC_E;
				break;
		case R.id.radio2:
			barCodeSystem = MetapacePrinter.BAR_CODE_EAN13;
				break;
		case R.id.radio3:
			barCodeSystem = MetapacePrinter.BAR_CODE_EAN8;
				break;
		case R.id.radio4:
			barCodeSystem = MetapacePrinter.BAR_CODE_CODE39;
				break;
		case R.id.radio5:
			barCodeSystem = MetapacePrinter.BAR_CODE_ITF;
				break;
		case R.id.radio6:
			barCodeSystem = MetapacePrinter.BAR_CODE_CODABAR;
				break;
		case R.id.radio7:
			barCodeSystem = MetapacePrinter.BAR_CODE_CODE93;
				break;
		case R.id.radio8:
			barCodeSystem = MetapacePrinter.BAR_CODE_CODE128;
				break;
		}
		
		String data = mDataEdit.getText().toString();
		if (data == null || data.length() == 0) {
			Toast.makeText(getApplicationContext(), "Input bar code data", Toast.LENGTH_SHORT).show();
			return;
		}
		
		int alignment = MetapacePrinter.ALIGNMENT_LEFT;
		radioGroup = (RadioGroup) findViewById(R.id.radioGroup2);
		switch (radioGroup.getCheckedRadioButtonId()) {
		case R.id.radio9:
			alignment = MetapacePrinter.ALIGNMENT_LEFT;
			break;
		case R.id.radio10:
			alignment = MetapacePrinter.ALIGNMENT_CENTER;
			break;
		case R.id.radio11:
			alignment = MetapacePrinter.ALIGNMENT_RIGHT;
			break;
		}
		
		EditText editText = (EditText) findViewById(R.id.editText2);
		String string = editText.getText().toString();
		if (string.length() == 0) {
			Toast.makeText(getApplicationContext(), "Please enter the width again.", Toast.LENGTH_SHORT).show();
			return;
		}
		int width = Integer.parseInt(string);
		
		editText = (EditText) findViewById(R.id.editText3);
		string = editText.getText().toString();
		if (string.length() == 0) {
			Toast.makeText(getApplicationContext(), "Please enter the height again.", Toast.LENGTH_SHORT).show();
			return;
		}
		int height = Integer.parseInt(string);
		
		int characterPosition = 0;
		radioGroup = (RadioGroup) findViewById(R.id.radioGroup3);
		switch (radioGroup.getCheckedRadioButtonId()) {
		case R.id.radio12:
			characterPosition = MetapacePrinter.HRI_CHARACTER_NOT_PRINTED;
			break;
		case R.id.radio13:
			characterPosition = MetapacePrinter.HRI_CHARACTERS_ABOVE_BAR_CODE;
			break;
		case R.id.radio14:
			characterPosition = MetapacePrinter.HRI_CHARACTERS_BELOW_BAR_CODE;
			break;
		case R.id.radio15:
			characterPosition = MetapacePrinter.HRI_CHARACTERS_ABOVE_AND_BELOW_BAR_CODE;
			break;
		}
		
		CheckBox checkBox = (CheckBox) findViewById(R.id.checkBox1);
		if (checkBox.isChecked()) {
			MainActivity.metapacePrinter.print1dBarcode(data, barCodeSystem, alignment, width, height, characterPosition, false);
			MainActivity.metapacePrinter.formFeed(true);
		} else {
			MainActivity.metapacePrinter.print1dBarcode(data, barCodeSystem, alignment, width, height, characterPosition, true);
		}
	}
}
